## -*-Tcl-*-
 # ==========================================================================
 #  WWW Menu - an extension package for Alpha
 # 
 #  FILE: "wwwMenu.tcl"
 #                                    created: 04/30/1997 {11:04:46 am} 
 #                                last update: 12/04/2001 {18:19:39 PM} 
 #  Author: Vince Darley
 #  E-mail: <vince@santafe.edu>
 #    mail: 317 Paseo de Peralta, Santa Fe, NM 87501, USA
 #     www: <http://www.santafe.edu/~vince/>
 #     
 #  Description:
 #  
 #  Procedures to build the WWW Menu, plus menu support.
 #  
 #  See the "wwwVersionHistory.tcl" file for license info, credits, etc.
 # ==========================================================================
 ##

alpha::menu wwwMenu 1.7 "global WWW HTML" "286" {
    menu::buildProc wwwMenu      WWW::buildMenu
    menu::buildProc bookmarks    WWW::buildBookmarks
    menu::buildProc goToPage     WWW::buildGoToPage
    set menu::posteval(wwwMenu)  WWW::postEval
    set menu::posteval(goToPage) WWW::postEval
    menu::buildSome wwwMenu
} {
    # Activation script
    wwwMenu
    WWW::OWH register
} {
    # Deactivation script
    WWW::OWH deregister
} maintainer {
    "Craig Barton Upright" <cupright@princeton.edu>
} uninstall {
    this-file
} help {
    The WWW Menu provides a simple text based (Lynx-like) HTML file browser, for
    reading local HTML files|| The WWW Mode provides a simple text based
    (Lynx-like) HTML file browser, for reading local HTML files||
	    
    The WWW Menu provides a simple text based (Lynx-like) HTML file browser, for
    reading local HTML files.  (When Alpha v8.0 arrives, support for browsing
    remote HTML files via HTTP will be possible, but until then you are stuck
    with browsing local files.)

    The rendering handles most common html tags, and the menu maintains a
    history list with a back/forward capability.  The menu can handle mailto,
    ftp and java applets itself; all other stuff is optionally shipped off to
    Internet Config.

    First insert the WWW Menu into the menu bar by selecting it in the prefs
    dialog "Config --> Preferences --> Menus".  Then open a local HTML file
    (that is a file on your own harddrive) and select "View this file" from the
    WWW Menu.  The page is rerendered in a new locked window.

    See the "WWW Example" for a rendering of the introductory page for Alpha's
    HTML mode manual.
    
    
	  	Navigating Links

    Navigation between links is accomplished with the arrowkeys or you can click
    with your mouse.  When a link is selected you can hit return to render the
    link in a new window.  WWW Menu maintains a browse history.  You can use the
    "Go To Page" cascade menu to select a page to view from your recent browsing
    history.  You can also select 'view source' from the menu.  Many keys are
    also bound to imitate the browser 'lynx'.

    Use the cursor keys, mouse or cmd-[] to move from web page to web page
    as follows:
    
      cmd-<- or cmd-[      go to previous page     
      cmd-]                go to next page
      cmd- -> or return    go to current link      
      up/down arrow        highlight previous/next link
      mouse-click          go to clicked-upon link

    Note that the forward/back menu items and key bindings only refer to the
    position relative to the 'current' window marked in the 'Go To Page'
    menu.
        
    The return key has several different functions attached to it, depending
    on the whether any modifiers are pressed.  All of these operate on the
    currently selected link.
    
      option-return:        edits the link in the original source file.
      control-return:       modifies the link in the rendered window.
      shift-return:         opens the link in a new WWW window.
      shift-control-return: sends the link to your local browser.

    Additional key bindings include:
    
      'a'             add the current window to the bookmarks menu.
      'b'             go back one item in the 'Go To' menu.
      'c'             copy the current link location to the clipboard.
      'e'             edit the source file of the current rendered window
      'f'             go forward one item in the 'Go To' menu.
      'g'             open a dialog with the 'Go To Page' menu items.
      'h'             open the History page.
      'o'             open the source file in Alpha/tk.
      'r'             reload the current window.
      's'             send the source file of the current window to browser.
      's' <command>   save the source file of the current window.
      'v'             open a dialog to view a url/file.
      
    Plus some others that you'll have to find by experimenting :)


	  	Advanced features:

    Using the WWW mode preferences you can ask Alpha to handle some URL types
    internally (currently mailto: and ftp: only, http: supported in Alphatk/8).
    Also Java applets may be sent to your javaviewer application (for example
    the 'Apple Applet Runner' which is free from apple).

    While in WWW mode, select Mode Prefs from the Config menu (F12) and set the
    flags appropriately.  Checking "WWW Send Remote Links" will automatically
    redirect any unlisted item (such as HTTP directives for Alpha 7) to your the
    application designated in Internet Config.  In Alphatk/8, http links can
    also be retrieved and rendered by the WWW Menu.

	  	To Do:

    Could be faster (i.e. it's probably useless on 680x0 machines), and it 
    would be nice if the proc: url::fetch actually worked in Alpha7.  However,
    it's reasonably useful for browsing local HTML documentation, and it renders
    remote urls in Alphatk/8 fairly well.  The parsing engine will always need
    improvement -- if you run across a url that the WWW menu handles poorly,
    please send that url to the WWW Menu's current maintainer, listed in the
    "Packages" help file.
}

# Make sure that the wwwMode.tcl file has been loaded.
wwwMode.tcl

namespace eval WWW {}

# Register quit, activate hooks.
hook::register quitHook       WWW::quitHook
hook::register activateHook   WWW::postEval

proc WWW::quitHook {} {temp::cleanup WWW-tmp}

# ===========================================================================
# 
#  ----  #
# 
#  WWW Menu  #
# 

proc wwwMenu {} {}

proc WWW::buildMenu {} {
    
    global wwwMenu WWW::NoUrls WWW::PrefsInMenu WWW::Pages WWW::Bookmarks
    global alpha::platform

    if {[set alpha::platform] == "alpha"} {
	set openWhere "openSourceInAlpha"
    } else {
        set openWhere "openSourceInAlphatk"
    }
    set optionItems [concat [set WWW::PrefsInMenu] \
      "(-)" "setHomePage" "flushCache" "wwwMenuHelp"]
    set searchItems [list \
      "/t<OwwwSearch1" "/t<IwwwSearch2" "/t<BwwwSearch3" "/t<UwwwSearch4"]
    if {[set WWW::NoUrls]} {set which "File"} else {set which "Url"}
    set menuList [list \
      "/S<U<OswitchToBrowser" \
      [list Menu    -n wwwMenuOptions -p WWW::menuProc -M WWW $optionItems] \
      "newWwwWindow" \
      "(-)" \
      "<SviewThisFile" "<Sview${which}" "/w<Ohome" \
      [list Menu -m -n goToPage  {}] \
      [list Menu -m -n bookmarks {}] \
      [list Menu    -n searchEngines -p WWW::searchProc -M WWW $searchItems] \
      "history" "(-)" \
      "/b<S<EselectLink" "/b<S<BmodifyLink" "/b<S<IeditLinkedDocument" \
      "/b<S<UlinkInNewWindow" "/b<S<U<BlinkToBrowser" "copyLinkLocation" "(-)" \
      "reload" "displayLinks" "<S$openWhere" "<SsendSourceToBrowser" \
      "/S<OsaveSourceFileAs" \
      ]
    # Alpha 7 can't handle these yet.
    if {[set WWW::NoUrls]} {
	set menuList [lremove $menuList \
	  [list Menu -n searchEngines -p WWW::searchProc -M WWW $searchItems]]
    }
    set submenus [list bookmarks goToPage]
    return [list build $menuList "WWW::menuProc -M WWW" $submenus $wwwMenu]
}

proc WWW::buildBookmarks {} {
    
    global WWW::Bookmarks
    
    set bookmarks [list "Add Bookmark"]
    if {[llength [array names WWW::Bookmarks]]} {
	set bookmarks [concat $bookmarks "(-)" \
	  [lsort -ignore [array names WWW::Bookmarks]] \
	  {"(-)" "Rename Bookmark" "Remove Bookmark"} ]
    }
    return [list build $bookmarks "WWW::navigationProc -m -M WWW" {}]
}
    
proc WWW::buildGoToPage {} {

    global WWW::Pages
    foreach item [set WWW::Pages] {
	lappend previousWindows [lindex $item 1]
    }
    lappend previousWindows "(-)" "/\[Back" "/\]Forward" "Clear List"
    return [list build $previousWindows "WWW::navigationProc -m -M WWW" {}]
}

proc WWW::postEval {args} {

    global global::features mode::features mode PREFS alpha::platform
    
    set test1 [lcontains global::features      wwwMenu]
    set test2 [lcontains mode::features($mode) wwwMenu]
    if {!$test1 && !$test2} {return}

    global wwwMenu WWW::Pages WWW::PagePos WWW::History WWW::Links
    global WWWmodeVars WWW::PrefsInMenu

    set title [win::Current]
    # Called when the mode is potentially changing.
    if {$mode == "WWW"}  {set dim1 1} else {set dim1 0}
    if {$mode == "HTML"} {set dim2 1} else {set dim2 0}
    set dim3 [expr {$dim1 + $dim2} ? 1 : 0]
    set dim4 0
    if {[llength [winNames]]} {
	set tmpDirs [file nativename [file join $PREFS tmp]]
	if {[string first $tmpDirs $title] != "-1" || $mode == "WWW"} {
	    set dim4 1
	}
    } 
    if {[set alpha::platform] == "alpha"} {
	set openWhere "openSourceInAlpha"
    } else {
	set openWhere "openSourceInAlphatk"
    }
    foreach item [list $openWhere displayLinks reload] {
	enableMenuItem $wwwMenu $item $dim1
    }
    enableMenuItem -m  bookmarks "Add Bookmark" $dim1
    foreach item [list viewThisFile] {
	enableMenuItem $wwwMenu $item $dim2
    } 
    foreach item [list sendSourceToBrowser] {
	enableMenuItem $wwwMenu $item $dim3
    } 
    foreach item [list saveSourceFileAs] {
	enableMenuItem $wwwMenu $item $dim4
    } 
    # Dim the 'History' item if necessary.
    set history [expr {[llength [set WWW::History]] > 1} ? 1 : 0]
    enableMenuItem $wwwMenu history      $history
    # Dim the 'Display Links' item if necessary.
    if {[set hasLinks [info exists WWW::Links($title)]]} {
	set hasLinks [expr {[llength [set WWW::Links($title)]] > 1} ? 1 : 0]
    } 
    enableMenuItem $wwwMenu displayLinks $hasLinks
    # Mark the 'WWW Menu Options' menu as necessary.
    foreach itemName [set WWW::PrefsInMenu] {
	if {[info exists WWWmodeVars($itemName)]} {
	    markMenuItem wwwMenuOptions $itemName $WWWmodeVars($itemName) 
	} 
    } 
    # Identify the current page in the 'Go To Page' menu.
    if {[set i [lsearch -glob [set WWW::Pages] [list * [lindex $args 0]]]] != -1} {
	set WWW::PagePos $i
    }
    # Synchronize the 'Go To Page' menu, or dim as necessary.
    if {[expr [set pages [llength [set WWW::Pages]]] ? 1 : 0]} {
	# We have a history of pages ...
	set forward [expr {[set WWW::PagePos] < [expr {$pages -1}]} ? 1 : 0]
	set back    [expr {[set WWW::PagePos] > 0} ? 1 : 0]
	enableMenuItem goToPage forward      $forward
	enableMenuItem goToPage back         $back
	set currentPage [lindex [lindex [set WWW::Pages] [set WWW::PagePos]] 1]
	foreach page [set WWW::Pages] {
	    set page [lindex $page 1]
	    if {$page == $currentPage} {
		markMenuItem -m goToPage $page 1 
	    } else {
		markMenuItem -m goToPage $page 0 
	    }
	}
    }
    enableMenuItem $wwwMenu goToPage [expr {$pages ? 1 : 0}]
    # Avoid unnecessarily loading wwwParsing.tcl if the menu is global
    WWW::postEvalLinks
}

proc WWW::postEvalLinks {} {

    global wwwMenu mode
    
    if {$mode != "WWW"} {
	set isALink 0
    } else {
	set isALink [isSelection]
    }
    if {$isALink && [catch {WWW::getCurrentLink "" 1} linkList]} {
        set isALink 0
    } 
    set linkMenuItems [list modifyLink selectLink editLinkedDocument \
      linkInNewWindow linkToBrowser copyLinkLocation ]
    foreach item $linkMenuItems {
	enableMenuItem $wwwMenu $item $isALink
    }
    if {$isALink} {
        set link [lindex $linkList 3]
	enableMenuItem $wwwMenu editLinkedDocument [regexp {^file:/[/]+} $link]
    } else {
	enableMenuItem $wwwMenu editLinkedDocument 0
    }
}

proc WWW::OWH {{which "register"}} {
    
    global wwwMenu alpha::platform
    
    if {[set alpha::platform] == "alpha"} {
	set openWhere "openSourceInAlpha"
    } else {
	set openWhere "openSourceInAlphatk"
    }
    # Dim some menu items when there are no open windows.
    set menuItems [list viewThisFile \
      selectLink modifyLink editLinkedDocument linkInNewWindow linkToBrowser \
      copyLinkLocation displayLinks reload $openWhere \
      sendSourceToBrowser saveSourceFileAs ]
    foreach i $menuItems {
	hook::${which} requireOpenWindowsHook [list $wwwMenu $i] 1
    } 
}

# ===========================================================================
# 
#  ----  #
# 
#  WWW Menu Support  #
# 

proc WWW::menuProc {menuName itemName args} {
    
    global browserSig mode alpha::platform WWWmodeVars wwwMenu
    global WWW::Pages WWW::PagePos WWW::FileSource WWW::Links WWW::LinksReverse
    global WWW::PrefsInMenu WWW::BaseUrl WWW::UrlSource
    global mode browserSig tcl_platform
    

    set navigationItems [list history clearHistory back forward \
      selectLink linkInNewWindow linkToBrowser]
    if {[lcontains navigationItems $itemName]} {
	WWW::navigationProc "" $itemName
	return
    }
    set title [win::Current]
    if {$menuName == "wwwMenuOptions"} {
	if {$itemName == "setHomePage"} {
	    set oldHP $WWWmodeVars(homePage)
	    set WWWmodeVars(homePage) [dialog::getUrl "New home page:" $oldHP]
	    prefs::modified WWWmodeVars(homePage)
	    set msg "'$WWWmodeVars(homePage)' is now your new home page."	    
	} elseif {$itemName == "flushCache"} {
	    catch {unset WWW::BaseUrl} ;    set WWW::BaseUrl()    [list ]
	    catch {unset WWW::FileSource} ; set WWW::FileSource() [list ]
	    WWW::quitHook
	    WWW::navigationProc "goToPage" "Clear List"
	    set msg "The WWW cache of files has been flushed."
	} elseif {$itemName == "wwwMenuHelp"} {
	    package::helpFile WWW
	} elseif {![lcontains WWW::PrefsInMenu $itemName]} {
	    status::errorMsg "Sorry, don't know what to do with '$itemName'"
	} else {
	    if {[getModifiers]} {
		# Open an alertnote with information about the preference.
		cache::readContents index::prefshelp
		if {[catch {set prefshelp(WWW,$itemName)} text]} {
		    set text "Sorry, no information is available for '$itemName'"
		} else {
		    catch {unset index::prefshelp}
		}
		if {$WWWmodeVars($itemName)} {
		    regsub {^.*\|\|} $text {} text
		} else {
		    regsub {\|\|.*$} $text {} text
		}
		alertnote "${text}."
	    } else {
		set WWWmodeVars($itemName) [expr {$WWWmodeVars($itemName) ? 0 : 1}]
		if {$mode == "WWW"} {
		    synchroniseModeVar $itemName $WWWmodeVars($itemName)
		} else {
		    prefs::modified WWWmodeVars($itemName)
		}
		markMenuItem wwwMenuOptions $itemName $WWWmodeVars($itemName) 
	    }
	    if {$WWWmodeVars($itemName)} {set end "on"} else {set end "off"}
	    set msg "The '$itemName' preference for the WWW menu is currently $end."
	}
	if {[info exists msg]} {status::msg $msg}
	return
    } 
    switch $itemName {
	"switchToBrowser"  {app::launchFore $browserSig}
	"newWwwWindow" {
	    # This is how we create two different browser windows, 
	    # even if the pref for 'use only one' is turned on.
	    set oldNewWindow $WWWmodeVars(linksOpenNewWindow)
	    set WWWmodeVars(linksOpenNewWindow) 1
	    eval WWW::renderUrl $args
	    set WWWmodeVars(linksOpenNewWindow) $oldNewWindow
	}
	"home"             {WWW::renderUrl $WWWmodeVars(homePage)}
	"viewFile"         {WWW::renderFile}
	"viewThisFile" {
	    if {$mode == "HTML"} {
		WWW::renderFile [win::Current]
	    } else {
		status::errorMsg "Cancelled -- file must be HTML to be viewed!"
	    }
	}
	"viewUrl" {WWW::renderUrl}
	"modifyLink" {
	    # Make sure that we have enough info to do this.
	    if {$mode != "WWW"} {
		dialog::errorAlert "Only useful in WWW browser mode."
	    } elseif {[catch {set WWW::FileSource($title)} fileSource]} {
		dialog::errorAlert "Sorry, can't identify the source for '$title'."
	    } elseif {![file exists $fileSource]} {
		dialog::errorAlert "Sorry, can't find '$fileSource'."
	    }
	    # Find the current link to modify.
	    set linkList [WWW::getCurrentLink]
	    set oldLink  [lindex $linkList 3]
	    if {[catch {dialog::getUrl "Enter new link location" $oldLink} to]} {
		status::errorMsg "Cancelled."
	    } elseif {$to == "" || $to == $oldLink} {
		status::msg "Nothing was changed."
		return
	    }
	    # Find out if the source is already open.
	    if {![catch {getWinInfo -w $fileSource i}]} {
		if {$i(dirty)} {
		    if {![dialog::yesno "Save original file?"]} {
			status::errorMsg "Cancelled."
		    } 
		    status::msg "Saving original file."
		    bringToFront $fileSource
		    save
		    bringToFront $title
		}
	    }
	    # Update the source file.
	    set reglink [quote::Regfind $oldLink]
	    set regto   [quote::Regsub $to]
	    set cid [alphaOpen $fileSource "r"]
	    if {[regsub -all -- $reglink [read $cid] $regto out]} {
		set ocid [alphaOpen $fileSource "w+"]
		puts -nonewline $ocid $out
		close $ocid
		status::msg "Updated original."
	    }
	    close $cid
	    if {![catch {bringToFront $fileSource}]} {
		status::msg "Updating window to agree with disk version."
		revert
		bringToFront $title
	    }
	    setWinInfo read-only 0	
	    WWW::makeLink [win::Current] [getPos] [selEnd] $to
	    setWinInfo read-only 1
	    # Now update the link lists.
	    set i1 [lsearch [set WWW::Links($title)] $linkList]
	    set i2 [lsearch [set WWW::LinksReverse($title)] $linkList]
	    set linkList [lreplace $linkList 2 2 "WWW::link \"$to\""] 
	    set linkList [lreplace $linkList 3 3 $to]
	    set WWW::Links($title)        [lreplace [set WWW::Links($title)]        $i1 $i1 $linkList]
	    set WWW::LinksReverse($title) [lreplace [set WWW::LinksReverse($title)] $i2 $i2 $linkList]
	    status::msg "WWW::link \"$to\""
	}
	"editLinkedDocument" {
	    set to [lindex [WWW::getCurrentLink "" 0] 3]
	    if {![regsub {^file:[/]+} $to {} fileSource]} {
	        status::errorMsg "Sorry, can only edit local files."
	    } 
	    regsub {\#.*$} [quote::Unurl $fileSource] {} fileSource
	    if {[catch {file::openQuietly $fileSource}]} {
	        status::errorMsg "Sorry, can't find the file '$fileSource'."
	    } 
	}
	"openSourceInAlphatk" -
	"openSourceInAlpha" {
	    if {$mode != "WWW"} {
		status::errorMsg "This item is only useful for rendered files."
	    } elseif {[catch {set WWW::FileSource($title)} sourceFile]} {
		status::errorMsg "Couldn't find the source of '$title'"
	    } elseif {[catch {file::openQuietly $sourceFile}]} {
		status::errorMsg "Couldn't find '$sourceFile'"
	    } else {
		status::msg "Source file of '$title'"
	    }
	}
	"sendSourceToBrowser" {
	    if {$mode == "HTML"} {
		set sourceFile [win::StripCount [win::Current]]
	    } elseif {[info exists WWW::FileSource($title)]} {
		set sourceFile [set WWW::FileSource($title)]
	    } else {
		status::errorMsg "Couldn't find the source of '$title'"   
	    }
	    # This was lifted from 'htmlSendWindow'.
	    if {$tcl_platform(platform) == "macintosh"} {
		if {![info exists browserSig] && [catch {getFileSig [icGetPref -t 1 Helperhttp]} browserSig]} {set browserSig MOSS}
		if {[catch {app::launchBack $browserSig}]} {
		    app::getSig "Please locate your web browser" browserSig
		    app::launchBack $browserSig
		}
		if {$browserSig == "MOSS"} {
		    sendOpenEvent noReply '$browserSig' $sourceFile
		} else {
		    regsub -all : $sourceFile / sourceFile
		    AEBuild '$browserSig' WWW! OURL "----" "file:///$sourceFile" FLGS 1
		}
	    } else {
		file::openInDefault $sourceFile ; return
	    }
	}
	"reload" {
	    if {$title == "* WWW History *"} {
		WWW::navigationProc "" history
		return
	    } elseif {[info exists WWW::FileSource($title)]} {
		set script [list WWW::renderFile [set WWW::FileSource($title)]]
	    } elseif {[info exists WWW::UrlSource($title)]} {
		set script [list WWW::renderUrl [set WWW::UrlSource($title)]]
	    } else {
		status::errorMsg "Couldn't find the source of '$title'."
	    }
	    # Remember where we are ...
	    getWinInfo winArray
	    set pos [rowColToPos $winArray(currline) 0]
	    # ... then reload the file from the source.
	    killWindow
	    eval $script
	    goto $pos ; insertToTop
	}
	"saveSourceFileAs" {
	    # This is different from the File menu item 'Save As' because
	    # when rendering the file we might have messed up some line
	    # endings, which would be a problem for .sit files (for example)
	    if {[file isfile $title]} {
	        set sourceFile $title
	    } elseif {[catch {set WWW::FileSource($title)} sourceFile]} {
		status::errorMsg "Couldn't find the source of '$title'"
	    }
	    set title [file tail $title]
	    set p "Save the source file of this '$title' window as:"
	    if {[catch {prompt $p $title} newName]} {
	        status::errorMsg "Cancelled."
	    } 
	    if {[catch {get_directory "Save '$newName' in:"} newDir]} {
		status::errorMsg "Cancelled."
	    }
	    set newFile [file join $newDir $newName]
	    if {[file exists $newFile]} {
		# Should we over-write the existing target?
		set    question "'${newName}' already exists in '${newDir}'.\r"
		append question "Do you want to replace it?"
		if {[askyesno $question] == "no"} {
		    status::msg "Cancelled." ; return
		}
	    } elseif {[catch {file copy $sourceFile $newFile}]} {
		status::msg "Failed to copy '$sourceFile' to '$newFile'"
	    } else {
		status::msg "'$newName' has been saved in '$newDir'."
	    }
	}
	"copyLinkLocation" {
	    set to [lindex [WWW::getCurrentLink "" 0] 3]
	    putScrap $to
	    status::msg "Copied to clipboard: $to"
	}
	default {eval WWW::$itemName}
    }
}

## 
 # -------------------------------------------------------------------------
 # 
 # "WWW::navigationProc" --
 # 
 #  Handles history navigation, as well as window-movement key bindings.
 # -------------------------------------------------------------------------
 ##

proc WWW::navigationProc {menuName itemName} {
    
    global WWW::Pages WWW::PagePos WWW::BaseUrl WWW::UrlSource WWW::FileSource
    global WWW::Bookmarks WWW::Pages WWW::PagePos wwwMenu

    switch -- $menuName {
	"goToPage" {
	    switch -- $itemName {
		"clearList" - "Clear List" {
		    # Reset variables, clear the menu.
		    set WWW::Pages   ""
		    set WWW::PagePos -1
		    menu::buildSome goToPage
		    status::msg "The 'Go To Page' menu has been emptied."
		}
		"back" - "Back" {
		    if {[set WWW::PagePos] > 0} {
			incr WWW::PagePos -1
			eval WWW::renderFile [lindex [set WWW::Pages] [set WWW::PagePos]]
		    } else {
			WWW::postEval
			beep
			status::msg "Already at first document."
		    }
		}
		"forward" - "Forward"  {
		    if {[set WWW::PagePos] < [expr [llength [set WWW::Pages]] -1]} {
			incr WWW::PagePos
			eval WWW::renderFile [lindex [set WWW::Pages] [set WWW::PagePos]]
		    } else {
			WWW::postEval
			beep
			status::msg "Already at most recent document."
		    }
		}
		default {
		    # Go to a history item.
		    if {![llength [set historyPages [set WWW::Pages]]]} {
			status::errorMsg "No pages are currently available."
		    } 
		    set which 0
		    foreach i $historyPages {
			if {![string length $itemName]} {
			    lappend pages [lindex $i 1]
			} elseif {[lindex $i 1] == $itemName || [lindex $i 1] == "$itemName"} {
			    catch {unset pages}
			    break
			}
			incr which
		    }
		    if {[info exists pages]} {
			# None was initially specified (or found), so offer the list.
			set L [lindex [lindex [set WWW::Pages] [set WWW::PagePos]] 1]
			if {[catch {listpick -p "Go to which page?" -L $L $pages} goToPage]} {
			    status::errorMsg "Cancelled."
			} else {
			    WWW::navigationProc "goToPage" $goToPage
			}
		    } elseif {$which >= [llength [set WWW::Pages]]} {
			alertnote "Sorry, I couldn't find that page!"
		    } else {
			set  WWW::PagePos $which
			eval WWW::renderFile [lindex [set WWW::Pages] [set WWW::PagePos]]
		    }
		}
	    }
	}
	"bookmarks" {
	    switch -- $itemName {
		"addBookmark" - "Add Bookmark" {
		    set w [win::Current]
		    if {[info exists WWW::UrlSource($w)]} {
			set sourceUrl [set WWW::UrlSource($w)]
		    } elseif {[info exists WWW::BaseUrl($w)]} {
			set sourceUrl [set WWW::BaseUrl($w)]
		    } else {
			# Make sure that items are properly dimmed.
			WWW::postEval 1
			status::errorMsg "Sorry, can't find the source file for '[win::CurrentTail]'."
		    }
		    set WWW::Bookmarks($w) $sourceUrl
		    prefs::modified WWW::Bookmarks($w)
		    menu::buildSome bookmarks ; WWW::postEval 1
		    status::msg "'$w' has been added to the bookmarks menu."
		}
		"renameBookmark" - "Rename Bookmark" {
		    set bookmarks [lsort -ignore [array names WWW::Bookmarks]]
		    if {![llength $bookmarks]} {
			status::msg "There are no bookmarks to rename."
			return
		    } 
		    set p "Rename which bookmarks"
		    if {[catch {listpick -p $p $bookmarks} result]} {
			status:errorMsg "Cancelled."
		    }
		    if {[catch {prompt "New name for '$result':" $result} newName]} {
			status::errorMsg "Cancelled."
		    } 
		    set WWW::Bookmarks($newName) [set WWW::Bookmarks($result)]
		    unset WWW::Bookmarks($result)
		    prefs::modified WWW::Bookmarks($result)
		    prefs::modified WWW::Bookmarks($newName)
		    menu::buildSome bookmarks ; WWW::postEval 1
		    status::msg "'$result' has been renamed to '$newName'."
		}
		"removeBookmark" - "Remove Bookmark" {
		    set bookmarks [lsort -ignore [array names WWW::Bookmarks]]
		    if {![llength $bookmarks]} {
			status::msg "There are no bookmarks to remove."
			return
		    } 
		    set p "Remove which bookmarks?"
		    if {[catch {listpick -l -p $p $bookmarks} result]} {
			status:errorMsg "Cancelled."
		    }
		    foreach bookmark $result {
			catch {unset WWW::Bookmarks($bookmark)}
			prefs::modified WWW::Bookmarks($bookmark)
		    }
		    menu::buildSome wwwMenu ; WWW::postEval 1
		    if {[llength $result] == "1"} {
			status::msg "$result has been removed."
		    } elseif {[llength $result] > "1"} {
			status::msg "$result have been removed."
		    }
		}
		default {
		    set w $itemName
		    if {![info exists WWW::Bookmarks($w)]} {
			status::errorMsg "Sorry, can't find the source file for '$w'."
		    }
		    WWW::link [set WWW::Bookmarks($w)]
		}
	    }
	}
	default {
	    switch -- $itemName {
		"up"         {WWW::nextLink 0 ; WWW::postEvalLinks}
		"down"       {WWW::nextLink 1 ; WWW::postEvalLinks}
		"selectLink" {WWW::link}
		"linkInNewWindow" {
		    set title [win::Current]
		    if {$title != "* WWW History *" && [info exists WWW::FileSource($title)]} {
			set f WWW::FileSource($title)
			WWW::addHistoryItem $f
		    } 
		    set to [lindex [WWW::getCurrentLink "" 0] 3]
		    WWW::visitedLink $to
		    WWW::menuProc $wwwMenu "newWwwWindow" $to
		}
		"linkToBrowser" {
		    set to [lindex [WWW::getCurrentLink "" 0] 3]
		    url::execute $to
		}
		"Home" {
		    goto [minPos]
		    WWW::postEvalLinks
		}
		"End" {
		    goto [maxPos]
		    WWW::postEvalLinks
		}
		"PageForward" {
		    pageForward
		    WWW::postEvalLinks
		}
		"PageBack" {
		    pageBack
		    WWW::postEvalLinks
		}
		"twoLinesForward" {
		    scrollDownLine
		    scrollDownLine
		}
		"twoLinesBack" {
		    scrollUpLine
		    scrollUpLine
		}
		"halfPageForward" {
		    getWinInfo winArray
		    set top   $winArray(currline)
		    set lines $winArray(linesdisp)
		    goto [rowColToPos [expr $top + $lines + (${lines}/2) - 1] 0]
		    WWW::postEvalLinks
		}
		"halfPageBack" {
		    getWinInfo winArray
		    set top   $winArray(currline)
		    set lines $winArray(linesdisp)
		    goto [rowColToPos [expr $top - ${lines}/2] 0]
		    WWW::postEvalLinks
		}
		default {WWW::$itemName}
	    }
	}
    }
}

proc WWW::searchProc {menuName itemName {text ""} {url ""}} {
    
    global WWWmodeVars
    
    regsub {wwwSearch} $itemName {} url

    if {![string length $url]} {
	set url $WWWmodeVars(searchUrl1)
    } elseif {[regexp {^[0-9]$} $url]} {
	set url $WWWmodeVars(searchUrl${url})
    } 
    if {![string length $text]} {
	regsub {^http://}           $url     {} urlName
	regsub {^www.}              $urlName {} urlName
	regsub {/+.*.$}             $urlName {} urlName
	regsub {^search\.}          $urlName {} urlName
	regsub {\.(com|org|net)$}   $urlName {} urlName
	if {[catch {getSelect} text]} {set text ""}
	set text [prompt "'$urlName' search for ... " $text] 
    } 
    set text [quote::Url $text]
    regsub -all {[ ]+} $text {+} textPlus
    set textPlus %22$text%22
    WWW::renderUrl $url$textPlus
}

proc WWW::massagePath {pp} {

    global tcl_platform

    upvar $pp p

    regsub {^[^:]+:/[/]+} $p {} p

    if {$tcl_platform(platform) == "macintosh"} {
	regsub -all "/" $p ":" p
	regsub -all {[^:]+:\.\.:} $p "" p
    } 
    set p [file nativename [quote::Unurl $p]]
}

# ===========================================================================
# 
# .